/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config;

import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.util.config.ConfigFileTask;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class SingleOptionFileTask
extends ConfigFileTask {
    private static final Logger logger = Logger.getLogger(SingleOptionFileTask.class.getName());

    @Override
    protected void readSourceConfigurable() throws Exception {
        if (this.oldFile != null) {
            try {
                if (!this.oldFile.exists()) {
                    logger.warning("Options file " + this.oldFile.getAbsolutePath() + " to patch from could not be found, no patches will be applied");
                    return;
                }
                logger.fine("Loading options file: " + this.oldFile.getAbsolutePath());
                this.fromConfigurable = new Options(this.oldFile);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        }
    }

    @Override
    protected void readConfigurable() throws Exception {
        if (this.newFile != null && this.newFile.exists()) {
            try {
                logger.fine("Loading original configuration file: " + this.newFile.getAbsolutePath());
                this.configurable = new Options(this.newFile);
            }
            catch (IOException ioe) {
                throw new Exception("Error opening original configuration file: " + ioe.toString());
            }
        } else if (this.toFile != null && this.toFile.exists()) {
            try {
                logger.fine("Loading target configuration file: " + this.toFile.getAbsolutePath());
                this.configurable = new Options(this.toFile);
            }
            catch (IOException ioe) {
                throw new Exception("Error opening target configuration file: " + ioe.toString());
            }
        } else {
            this.configurable = new Options();
        }
    }

    @Override
    protected void writeConfigurable() throws Exception {
        try {
            if (!this.toFile.exists()) {
                if (this.createConfigurable) {
                    File parent = this.toFile.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    logger.fine("Creating empty properties file: " + this.toFile.getAbsolutePath());
                    this.toFile.createNewFile();
                } else {
                    logger.warning("Options file " + this.toFile.getAbsolutePath() + " did not exist and is not allowed to be created");
                    return;
                }
            }
            Options opts = (Options)this.configurable;
            opts.setFile(this.toFile);
            opts.setHeaderComment(this.getComment());
            opts.store();
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
        if (this.oldFile != null && this.cleanup && this.oldFile.exists() && !this.oldFile.delete()) {
            logger.warning("File " + this.oldFile + " could not be cleant up");
        }
    }
}

