/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.merge;

import com.izforge.izpack.util.xmlmerge.AbstractXmlMergeException;
import com.izforge.izpack.util.xmlmerge.DocumentException;
import com.izforge.izpack.util.xmlmerge.MergeAction;
import com.izforge.izpack.util.xmlmerge.OperationFactory;
import com.izforge.izpack.util.xmlmerge.ParseException;
import com.izforge.izpack.util.xmlmerge.XmlMerge;
import com.izforge.izpack.util.xmlmerge.action.FullMergeAction;
import com.izforge.izpack.util.xmlmerge.factory.StaticOperationFactory;
import com.izforge.izpack.util.xmlmerge.mapper.IdentityMapper;
import com.izforge.izpack.util.xmlmerge.matcher.AttributeMatcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.DOMBuilder;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.DOMOutputter;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class DefaultXmlMerge
implements XmlMerge {
    private MergeAction m_rootMergeAction = new FullMergeAction();

    public DefaultXmlMerge() {
        this.setRootMergeActionFactory(new StaticOperationFactory(new FullMergeAction()));
        this.setRootMergeMatcherFactory(new StaticOperationFactory(new AttributeMatcher()));
        this.setRootMergeMapperFactory(new StaticOperationFactory(new IdentityMapper()));
    }

    @Override
    public void setRootMergeActionFactory(OperationFactory factory) {
        this.m_rootMergeAction.setActionFactory(factory);
    }

    @Override
    public void setRootMergeMatcherFactory(OperationFactory factory) {
        this.m_rootMergeAction.setMatcherFactory(factory);
    }

    @Override
    public void setRootMergeMapperFactory(OperationFactory factory) {
        this.m_rootMergeAction.setMapperFactory(factory);
    }

    @Override
    public String merge(String[] sources) throws AbstractXmlMergeException {
        InputStream[] inputStreams = new InputStream[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            inputStreams[i] = new ByteArrayInputStream(sources[i].getBytes());
        }
        InputStream merged = this.merge(inputStreams);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = merged.read(buffer)) != -1) {
                result.write(buffer, 0, len);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result.toString();
    }

    @Override
    public org.w3c.dom.Document merge(org.w3c.dom.Document[] sources) throws AbstractXmlMergeException {
        DOMBuilder domb = new DOMBuilder();
        Document[] docs = new Document[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            docs[i] = domb.build(sources[i]);
        }
        Document result = this.doMerge(docs);
        DOMOutputter outputter = new DOMOutputter();
        try {
            return outputter.output(result);
        }
        catch (JDOMException e) {
            throw new DocumentException(result, (Throwable)e);
        }
    }

    @Override
    public InputStream merge(InputStream[] sources) throws AbstractXmlMergeException {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Document[] docs = new Document[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            try {
                docs[i] = builder.build(sources[i]);
                continue;
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        Document result = this.doMerge(docs);
        Format prettyFormatter = Format.getPrettyFormat();
        prettyFormatter.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter sortie = new XMLOutputter(prettyFormatter);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            sortie.output(result, (OutputStream)buffer);
        }
        catch (IOException ex) {
            throw new DocumentException(result, (Throwable)ex);
        }
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    @Override
    public void merge(File[] sources, File target) throws AbstractXmlMergeException {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Document[] docs = new Document[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            try {
                docs[i] = builder.build(sources[i]);
                continue;
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        Document result = this.doMerge(docs);
        Format prettyFormatter = Format.getPrettyFormat();
        prettyFormatter.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter sortie = new XMLOutputter(prettyFormatter);
        try {
            sortie.output(result, (OutputStream)new FileOutputStream(target));
        }
        catch (IOException ex) {
            throw new DocumentException(result, (Throwable)ex);
        }
    }

    private Document doMerge(Document[] docs) throws AbstractXmlMergeException {
        Document originalDoc = docs[0];
        Element origRootElement = originalDoc.getRootElement();
        for (int i = 1; i < docs.length; ++i) {
            Element comparedRootElement = docs[i].getRootElement();
            Document output = new Document();
            if (originalDoc.getDocType() != null) {
                output.setDocType(originalDoc.getDocType().clone());
            }
            output.setRootElement(new Element("root"));
            Element outputRootElement = output.getRootElement();
            this.m_rootMergeAction.perform(origRootElement, comparedRootElement, outputRootElement);
            Element root = (Element)outputRootElement.getChildren().get(0);
            root.detach();
            DefaultXmlMerge.sortRootChildrenRecursive(root);
            originalDoc.setRootElement(root);
        }
        return originalDoc;
    }

    private static void sortRootChildrenRecursive(Element root) {
        DefaultXmlMerge.sortRootChildrenRecursive(root, new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    private static void sortRootChildrenRecursive(Element root, Comparator<Element> comparator) {
        for (Element element : root.getChildren()) {
            DefaultXmlMerge.sortRootChildrenRecursive(element, comparator);
        }
        root.sortChildren(comparator);
    }
}

