/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.xinfo;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.gui.LayoutHelper;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class XInfoPanel
extends IzPanel {
    private static final long serialVersionUID = 3257009856274970416L;
    private JTextArea textArea;
    private String info;

    public XInfoPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources) {
        super(panel, parent, installData, resources);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.setLayout(layout);
        JLabel infoLabel = LabelFactory.create(this.getString("InfoPanel.info"), (Icon)parent.getIcons().get("edit"), 11);
        LayoutHelper.buildConstraints(gbConstraints, 0, 0, 1, 1, 1.0, 0.0);
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        gbConstraints.fill = 1;
        gbConstraints.anchor = 16;
        layout.addLayoutComponent(infoLabel, gbConstraints);
        this.add(infoLabel);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        String textAreaFont = installData.getVariable("XInfoPanel.font");
        if (textAreaFont != null && textAreaFont.length() > 0) {
            Font font = Font.decode(textAreaFont);
            this.textArea.setFont(font);
        }
        JScrollPane scroller = new JScrollPane(this.textArea);
        LayoutHelper.buildConstraints(gbConstraints, 0, 1, 1, 1, 1.0, 0.9);
        gbConstraints.anchor = 10;
        layout.addLayoutComponent(scroller, gbConstraints);
        this.add(scroller);
    }

    private void loadInfo() {
        this.info = this.getResources().getString("XInfoPanel.info", null, "Error : could not load the info text !");
    }

    private void parseText() {
        this.info = this.installData.getVariables().replace(this.info);
    }

    @Override
    public void panelActivate() {
        this.loadInfo();
        this.parseText();
        this.textArea.setText(this.info);
        this.textArea.setCaretPosition(0);
    }

    @Override
    public boolean isValidated() {
        return true;
    }
}

