/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.unpacker.PackResources;
import java.io.InputStream;

public abstract class AbstractPackResources
implements PackResources {
    protected static final String WEB_TEMP_SUB_PATH = "/IzpackWebTemp";
    private final Resources resources;
    private final InstallData installData;

    public AbstractPackResources(Resources resources, InstallData installData) {
        this.installData = installData;
        this.resources = resources;
    }

    @Override
    public InputStream getPackStream(String name) {
        String webDirURL = this.installData.getInfo().getWebDirURL();
        InputStream result = webDirURL == null ? this.getLocalPackStream(name) : this.getWebPackStream(name, webDirURL);
        return result;
    }

    @Override
    public InputStream getInputStream(String name) {
        return this.resources.getInputStream(name);
    }

    private InputStream getLocalPackStream(String name) {
        return this.resources.getInputStream("packs/pack-" + name);
    }

    protected abstract InputStream getWebPackStream(String var1, String var2);

    protected InstallData getInstallData() {
        return this.installData;
    }
}

