/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Constants.CL_Constants;
import SplashScreen.CL_AsyncImageLoader;
import SplashScreen.CL_SplashScreen;
import Util.CL_File;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.embed.swing.JFXPanel;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CL_Application
implements CL_Constants {
    public static String m_sLang = "FRA";
    public static String m_sStyle = null;
    public static String DEFAULT_JAR = System.getProperty("user.dir");
    public static String URL_STREAM = "NO_STREAM";
    private JFrame f = null;
    private JButton btnPlay = null;
    private JButton btnMute = null;
    private JButton btnWeb = null;
    private JButton btnClose = null;
    private JLabel lblTime = null;
    private JLabel lblInfo = null;
    private boolean isAlive = false;
    private Media media = null;
    private MediaPlayer player = null;
    private JComboBox<String> m_cboURL = null;
    private JSpinner spiVolume = null;
    private double m_dVolume = 0.0;
    private String m_sVolume = "";
    private boolean m_isMute = false;
    private String m_sWeb = "NO_WEBSITE";
    private MapChangeListener<String, Object> metadataChangeListener;
    public static final String TAG_COLUMN_NAME = "Tag";
    public static final String VALUE_COLUMN_NAME = "Value";
    public ArrayList<String> arlWebSites = new ArrayList();

    public CL_Application() {
        CL_SplashScreen f1 = new CL_SplashScreen();
        f1.setUndecorated(true);
        f1.positionAtCenter(1, 1);
        f1.setVisible(true);
        CL_AsyncImageLoader loader = new CL_AsyncImageLoader(f1);
        loader.start();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        f1.setVisible(false);
        Random rn = new Random();
        if (rn.nextInt(20) == 0 && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI("https://redirections.europesoftwares.net/redirections.aspx?SOFTWARE=SS0"));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        rn = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JFXPanel();
            }
        });
        this.f = new JFrame();
        this.f.setTitle("EuropeSoftwares SimpleStreamPlayer v2025.7.22");
        this.f.setDefaultCloseOperation(3);
        this.f.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/Images/simplestreamplayer.png")));
        this.f.setUndecorated(true);
        MoveListener listener = new MoveListener();
        this.f.addMouseListener(listener);
        this.f.addMouseMotionListener(listener);
        final JDialog d = new JDialog();
        d.setTitle("EuropeSoftwares SimpleStreamPlayer v2025.7.22");
        d.setLayout(new GridBagLayout());
        d.setUndecorated(true);
        d.setModal(true);
        JPanel pd = new JPanel();
        pd.setLayout(new GridBagLayout());
        pd.setBorder(BorderFactory.createMatteBorder(2, 12, 2, 12, Color.black));
        GridBagConstraints cd = new GridBagConstraints();
        cd.fill = 0;
        cd.anchor = 17;
        cd.ipadx = 0;
        cd.ipady = 0;
        cd.gridx = 0;
        cd.gridy = 0;
        this.m_cboURL = new JComboBox();
        this.m_cboURL.setFont(FONT_ARIAL_PLAIN_12);
        this.m_cboURL.setPreferredSize(new Dimension(790, 22));
        this.m_cboURL.setEditable(true);
        this.m_cboURL.getEditor().getEditorComponent().setForeground(Color.black);
        this.m_cboURL.getEditor().getEditorComponent().setBackground(new Color(251, 170, 153));
        if (URL_STREAM.equals("NO_STREAM")) {
            if (new File("FLUX.TXT").exists()) {
                ArrayList<String> arlLines = CL_File.readListFromFile(new File("FLUX.TXT"));
                int i = 0;
                while (i < arlLines.size()) {
                    if (arlLines.get(i).contains(";")) {
                        this.m_cboURL.addItem(arlLines.get(i).substring(0, arlLines.get(i).indexOf(";")));
                        this.arlWebSites.add(arlLines.get(i).substring(arlLines.get(i).indexOf(";") + 1, arlLines.get(i).length()));
                    } else {
                        this.m_cboURL.addItem(arlLines.get(i));
                        this.arlWebSites.add("NO_WEBSITE");
                    }
                    ++i;
                }
            } else {
                this.m_cboURL.addItem("[BFMBUSINESS]http://audio.bfmtv.com/bfmbusiness_128.mp3");
                this.m_cboURL.addItem("[CHERIEFM]http://cdn.nrjaudio.fm/adwz2/fr/30201/mp3_128.mp3");
                this.m_cboURL.addItem("[EUROPE1]http://europe1.lmn.fm/europe1.mp3");
                this.m_cboURL.addItem("[EUROPE2]http://europe2.lmn.fm/europe2.mp3");
                this.m_cboURL.addItem("[FIP]http://icecast.radiofrance.fr/fip-midfi.mp3");
                this.m_cboURL.addItem("[FRANCEINFO]http://icecast.radiofrance.fr/franceinfo-midfi.mp3");
                this.m_cboURL.addItem("[FRANCEINTER]http://icecast.radiofrance.fr/franceinter-midfi.mp3");
                this.m_cboURL.addItem("[FRANCECULTURE]http://icecast.radiofrance.fr/franceculture-midfi.mp3");
                this.m_cboURL.addItem("[FRANCEMUSIQUE]http://icecast.radiofrance.fr/francemusique-midfi.mp3");
                this.m_cboURL.addItem("[FUNRADIO]http://icecast.funradio.fr/fun-1-44-128");
                this.m_cboURL.addItem("[ICI]http://icecast.radiofrance.fr/fb1071-midfi.mp3");
                this.m_cboURL.addItem("[JAZZRADIO]http://broadcast.infomaniak.ch/jazzradio-high.mp3");
                this.m_cboURL.addItem("[MFM]http://mfm.ice.infomaniak.ch/mfm-128.mp3");
                this.m_cboURL.addItem("[MOUV]http://icecast.radiofrance.fr/mouv-midfi.mp3");
                this.m_cboURL.addItem("[NOSTALGIE]http://cdn.nrjaudio.fm/adwz2/fr/30601/mp3_128.mp3");
                this.m_cboURL.addItem("[NRJ]http://cdn.nrjaudio.fm/adwz2/fr/30001/mp3_128.mp3");
                this.m_cboURL.addItem("[OUIFM]http://ouifm.ice.infomaniak.ch/ouifm-high.mp3");
                this.m_cboURL.addItem("[RADIOCLASSIQUE]http://radioclassique.ice.infomaniak.ch/radioclassique-high.mp3");
                this.m_cboURL.addItem("[RIREETCHANSONS]http://cdn.nrjaudio.fm/adwz2/fr/30401/mp3_128.mp3");
                this.m_cboURL.addItem("[RFM]http://rfm.lmn.fm/rfm.mp3");
                this.m_cboURL.addItem("[RMC]http://audio.bfmtv.com/rmcradio_128.mp3");
                this.m_cboURL.addItem("[RTL]http://streaming.radio.rtl.fr/rtl-1-44-128");
                this.m_cboURL.addItem("[RTL2]http://streaming.radio.rtl2.fr/rtl2-1-44-128");
                this.m_cboURL.addItem("[SKYROCK]http://icecast.skyrock.net/s/natio_mp3_128k");
                this.m_cboURL.addItem("[TOPMUSIC]http://sc.creacast.com/topmusic_strasbourg");
            }
        } else {
            if (URL_STREAM.contains(";")) {
                this.m_cboURL.addItem(URL_STREAM.substring(0, URL_STREAM.indexOf(";")));
                this.arlWebSites.add(URL_STREAM.substring(URL_STREAM.indexOf(";") + 1, URL_STREAM.length()));
            } else {
                this.m_cboURL.addItem(URL_STREAM);
                this.arlWebSites.add("NO_WEBSITE");
            }
            this.m_cboURL.setEnabled(false);
        }
        pd.add(this.m_cboURL, cd);
        cd.gridx = 1;
        cd.gridy = 0;
        JButton btnOK = new JButton();
        btnOK.setIcon(new ImageIcon(this.getClass().getResource("/Images/icon_right.png")));
        btnOK.setPreferredSize(new Dimension(30, 22));
        btnOK.setBorderPainted(true);
        btnOK.setFocusPainted(true);
        btnOK.setBackground(new Color(251, 170, 153));
        btnOK.setContentAreaFilled(true);
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                d.setVisible(false);
                CL_Application.this.setWeb();
                CL_Application.this.play();
            }
        });
        pd.add((Component)btnOK, cd);
        d.add(pd);
        d.pack();
        d.setLocationRelativeTo(this.f);
        d.setResizable(false);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, new Color(221, 81, 50)));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 17;
        c.ipadx = 0;
        c.ipady = 0;
        c.gridx = 0;
        c.gridy = 0;
        JLabel btnIcon = new JLabel(new ImageIcon(this.getClass().getResource("/Images/LOGOEuropeSoftwares_32x32.gif")));
        btnIcon.setPreferredSize(new Dimension(30, 30));
        btnIcon.setToolTipText("https://www.europesoftwares.net/");
        btnIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://www.europesoftwares.net/default.aspx"));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        p.add((Component)btnIcon, c);
        c.gridx = 1;
        c.gridy = 0;
        this.btnPlay = new JButton("\u25ba");
        p.add((Component)this.btnPlay, c);
        this.btnPlay.setPreferredSize(new Dimension(45, 30));
        this.btnPlay.setBorderPainted(true);
        this.btnPlay.setFocusPainted(false);
        this.btnPlay.setContentAreaFilled(false);
        this.btnPlay.setFont(FONT_ARIAL_PLAIN_12);
        this.btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CL_Application.this.player == null) {
                    if (CL_Application.this.m_cboURL.getItemCount() == 1) {
                        CL_Application.this.play();
                    } else {
                        d.setLocationRelativeTo(CL_Application.this.f);
                        d.setVisible(true);
                    }
                } else {
                    CL_Application.this.stop();
                }
            }
        });
        c.gridx = 2;
        c.gridy = 0;
        this.lblTime = new JLabel("00:00:00", 0);
        this.lblTime.setFont(FONT_ARIAL_PLAIN_14);
        this.lblTime.setForeground(Color.RED);
        this.lblTime.setPreferredSize(new Dimension(65, 20));
        p.add((Component)this.lblTime, c);
        c.gridx = 3;
        c.gridy = 0;
        this.lblInfo = new JLabel("...");
        this.lblInfo.setFont(FONT_ARIAL_PLAIN_12);
        this.lblInfo.setForeground(Color.BLUE);
        this.lblInfo.setPreferredSize(new Dimension(500, 20));
        p.add((Component)this.lblInfo, c);
        c.gridx = 4;
        c.gridy = 0;
        p.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/Images/icon_volume.png"))), c);
        c.gridx = 5;
        c.gridy = 0;
        p.add((Component)new JLabel(" "), c);
        c.gridx = 6;
        c.gridy = 0;
        this.spiVolume = new JSpinner(new SpinnerNumberModel(75, 0, 100, 1));
        this.spiVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (CL_Application.this.player != null) {
                    CL_Application.this.player.setVolume(Double.parseDouble(((JSpinner.NumberEditor)CL_Application.this.spiVolume.getEditor()).getTextField().getText()) / 100.0);
                    CL_Application.this.m_isMute = false;
                }
            }
        });
        this.spiVolume.setFont(FONT_ARIAL_BOLD_14);
        this.spiVolume.setPreferredSize(new Dimension(45, 30));
        ((JSpinner.NumberEditor)this.spiVolume.getEditor()).getTextField().setEditable(false);
        ((JSpinner.NumberEditor)this.spiVolume.getEditor()).getTextField().setHorizontalAlignment(4);
        p.add((Component)this.spiVolume, c);
        c.gridx = 7;
        c.gridy = 0;
        this.btnMute = new JButton();
        p.add((Component)this.btnMute, c);
        this.btnMute.setIcon(new ImageIcon(this.getClass().getResource("/Images/icon_mute.png")));
        this.btnMute.setBorderPainted(true);
        this.btnMute.setFocusPainted(false);
        this.btnMute.setContentAreaFilled(false);
        this.btnMute.setFont(FONT_ARIAL_BOLD_9);
        this.btnMute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CL_Application.this.player != null) {
                    if (!CL_Application.this.m_isMute) {
                        CL_Application.this.m_dVolume = CL_Application.this.player.getVolume();
                        CL_Application.this.m_sVolume = ((JSpinner.NumberEditor)CL_Application.this.spiVolume.getEditor()).getTextField().getText();
                        CL_Application.this.player.setVolume(0.0);
                        ((JSpinner.NumberEditor)CL_Application.this.spiVolume.getEditor()).getTextField().setText("0");
                        CL_Application.this.m_isMute = true;
                    } else {
                        CL_Application.this.player.setVolume(CL_Application.this.m_dVolume);
                        ((JSpinner.NumberEditor)CL_Application.this.spiVolume.getEditor()).getTextField().setText(CL_Application.this.m_sVolume);
                        CL_Application.this.m_isMute = false;
                    }
                }
            }
        });
        c.gridx = 8;
        c.gridy = 0;
        this.btnWeb = new JButton();
        p.add((Component)this.btnWeb, c);
        this.btnWeb.setIcon(new ImageIcon(this.getClass().getResource("/Images/icon_web.png")));
        this.btnWeb.setBorderPainted(true);
        this.btnWeb.setFocusPainted(false);
        this.btnWeb.setContentAreaFilled(false);
        this.btnWeb.setFont(FONT_ARIAL_BOLD_9);
        this.btnWeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CL_Application.this.m_sWeb.equals("NO_WEBSITE") && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(new URI(CL_Application.this.m_sWeb));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        c.gridx = 9;
        c.gridy = 0;
        this.btnClose = new JButton();
        p.add((Component)this.btnClose, c);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/Images/icon_close.png")));
        this.btnClose.setBorderPainted(true);
        this.btnClose.setFocusPainted(false);
        this.btnClose.setContentAreaFilled(false);
        this.btnClose.setFont(FONT_ARIAL_BOLD_9);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CL_Application.this.stop();
                System.exit(0);
            }
        });
        this.btnMute.setEnabled(false);
        this.spiVolume.setEnabled(false);
        this.btnWeb.setEnabled(false);
        this.f.getContentPane().add(p);
        this.f.pack();
        this.f.setLocationRelativeTo(null);
        this.f.setResizable(false);
        this.f.setVisible(true);
        if (!URL_STREAM.equals("NO_STREAM")) {
            this.setWeb();
            this.play();
        }
    }

    private void setWeb() {
        if (this.arlWebSites.size() > 0) {
            if (!this.arlWebSites.get(this.m_cboURL.getSelectedIndex()).equals("NO_WEBSITE")) {
                this.m_sWeb = this.arlWebSites.get(this.m_cboURL.getSelectedIndex());
                this.btnWeb.setEnabled(true);
            } else {
                this.btnWeb.setEnabled(false);
            }
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[BFMBUSINESS]")) {
            this.m_sWeb = "https://bfmbusiness.bfmtv.com/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[CHERIEFM]")) {
            this.m_sWeb = "https://www.cheriefm.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[EUROPE1]")) {
            this.m_sWeb = "https://www.europe1.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[EUROPE2]")) {
            this.m_sWeb = "https://www.europe2.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[FIP]")) {
            this.m_sWeb = "https://www.fipradio.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[FRANCEINFO]")) {
            this.m_sWeb = "https://www.franceinfo.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[FRANCEINTER]")) {
            this.m_sWeb = "https://www.franceinter.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[FRANCECULTURE]")) {
            this.m_sWeb = "https://www.franceculture.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[FRANCEMUSIQUE]")) {
            this.m_sWeb = "https://www.francemusique.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[FUNRADIO]")) {
            this.m_sWeb = "https://www.funradio.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[ICI]")) {
            this.m_sWeb = "https://www.ici.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[JAZZRADIO]")) {
            this.m_sWeb = "https://www.jazzradio.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[MFM]")) {
            this.m_sWeb = "https://mradio.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[MOUV]")) {
            this.m_sWeb = "https://www.lemouv.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[NOSTALGIE]")) {
            this.m_sWeb = "https://www.nostalgie.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[NRJ]")) {
            this.m_sWeb = "https://nrj.com/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[OUIFM]")) {
            this.m_sWeb = "https://www.ouifm.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[RADIOCLASSIQUE]")) {
            this.m_sWeb = "https://www.radioclassique.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[RIREETCHANSONS]")) {
            this.m_sWeb = "https://www.rireetchansons.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[RFM]")) {
            this.m_sWeb = "https://www.rfm.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[RMC]")) {
            this.m_sWeb = "https://rmc.bfmtv.com/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[RTL]")) {
            this.m_sWeb = "https://www.rtl.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[RTL2]")) {
            this.m_sWeb = "https://www.rtl2.fr/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[SKYROCK]")) {
            this.m_sWeb = "https://skyrock.fm/";
            this.btnWeb.setEnabled(true);
        } else if (this.m_cboURL.getSelectedItem().toString().startsWith("[TOPMUSIC]")) {
            this.m_sWeb = "https://www.topmusic.fr/";
            this.btnWeb.setEnabled(true);
        } else {
            this.m_sWeb = "NO_WEBSITE";
            this.btnWeb.setEnabled(false);
        }
    }

    private void play() {
        this.lblInfo.setText(this.m_cboURL.getSelectedItem().toString());
        this.btnPlay.setText("\u25a0");
        if (this.media != null) {
            this.media = null;
        }
        if (this.player != null) {
            this.player = null;
        }
        try {
            this.media = this.m_cboURL.getSelectedItem().toString().contains("]") ? new Media(new URI(this.m_cboURL.getSelectedItem().toString().substring(this.m_cboURL.getSelectedItem().toString().indexOf("]") + 1, this.m_cboURL.getSelectedItem().toString().length())).toString()) : new Media(new URI(this.m_cboURL.getSelectedItem().toString()).toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.media.getMetadata().addListener((MapChangeListener)new MapChangeListener<String, Object>(){

            public void onChanged(MapChangeListener.Change<? extends String, ?> c) {
                if (c.wasAdded()) {
                    String artist = "";
                    String album = "";
                    String title = "";
                    if (((String)c.getKey()).equals("artist") && c.wasAdded()) {
                        artist = (String)c.getValueAdded();
                    }
                    if (((String)c.getKey()).equals("album") && c.wasAdded()) {
                        album = (String)c.getValueAdded();
                    }
                    if (((String)c.getKey()).equals("title") && c.wasAdded()) {
                        title = (String)c.getValueAdded();
                    }
                    CL_Application.this.lblInfo.setText(">" + artist + "/" + album + "/" + title);
                }
            }
        });
        this.player = new MediaPlayer(this.media);
        this.player.seek(Duration.ZERO);
        this.setMetaDataDisplay((ObservableMap<String, Object>)this.player.getMedia().getMetadata());
        this.player.setVolume(Double.parseDouble(((JSpinner.NumberEditor)this.spiVolume.getEditor()).getTextField().getText()) / 100.0);
        this.player.setOnError(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, CL_Application.this.player.getError().getMessage());
                CL_Application.this.stop();
            }
        });
        this.player.setOnReady(new Runnable(){

            @Override
            public void run() {
                CL_Application.this.player.play();
                CL_Application.this.btnMute.setEnabled(true);
                CL_Application.this.spiVolume.setEnabled(true);
            }
        });
        this.lblTime.setForeground(new Color(0, 187, 119));
        new timeThread().start();
    }

    public void stop() {
        this.isAlive = false;
        this.btnMute.setEnabled(false);
        this.btnWeb.setEnabled(false);
        this.spiVolume.setEnabled(false);
        this.btnPlay.setText("\u25ba");
        this.lblTime.setForeground(Color.RED);
        if (this.player != null) {
            this.player.stop();
            this.resetMetaDataDisplay((ObservableMap<String, Object>)this.player.getMedia().getMetadata());
            this.player.dispose();
            this.player = null;
        }
    }

    private void setMetaDataDisplay(final ObservableMap<String, Object> metadata) {
        this.setMetadataToTableData(metadata);
        this.metadataChangeListener = new MapChangeListener<String, Object>(){

            public void onChanged(MapChangeListener.Change<? extends String, ?> change) {
                CL_Application.this.setMetadataToTableData((ObservableMap<String, Object>)metadata);
            }
        };
        metadata.addListener(this.metadataChangeListener);
    }

    private void resetMetaDataDisplay(ObservableMap<String, Object> metadata) {
        metadata.removeListener(this.metadataChangeListener);
    }

    private void setMetadataToTableData(ObservableMap<String, Object> metadata) {
        String sInfo = "";
        for (String key : metadata.keySet()) {
            HashMap<String, Object> dataRow = new HashMap<String, Object>();
            dataRow.put(TAG_COLUMN_NAME, key);
            dataRow.put(VALUE_COLUMN_NAME, metadata.get((Object)key));
            sInfo = String.valueOf(sInfo) + ">" + metadata.get((Object)key);
        }
        if (!sInfo.equals("")) {
            this.lblInfo.setText(sInfo);
        }
    }

    private String to000000(long _l) {
        long h = _l / 1000L / 60L / 60L;
        long m = _l / 1000L / 60L - h * 60L;
        long s = _l / 1000L - 60L * m - h * 60L * 60L;
        return String.valueOf(this.addZero(h)) + ":" + this.addZero(m) + ":" + this.addZero(s);
    }

    private String addZero(long _l) {
        if (_l < 10L) {
            return "0" + _l;
        }
        return "" + _l;
    }

    public static void main(String[] args) {
        Thread.currentThread().setPriority(1);
        if (args.length == 1) {
            URL_STREAM = args[0];
        }
        new CL_Application();
    }

    class MoveListener
    implements MouseListener,
    MouseMotionListener {
        private Point pressedPoint;
        private Rectangle frameBounds;
        private Date lastTimeStamp;

        MoveListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.frameBounds = CL_Application.this.f.getBounds();
            this.pressedPoint = event.getPoint();
            this.lastTimeStamp = new Date();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.moveJFrame(event);
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            this.moveJFrame(event);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        private void moveJFrame(MouseEvent event) {
            Point endPoint = event.getPoint();
            int xDiff = endPoint.x - this.pressedPoint.x;
            int yDiff = endPoint.y - this.pressedPoint.y;
            Date timestamp = new Date();
            if (Math.abs(timestamp.getTime() - this.lastTimeStamp.getTime()) > 60L) {
                if (xDiff > 0 || yDiff > 0 || xDiff < 0 || yDiff < 0) {
                    this.frameBounds.x += xDiff;
                    this.frameBounds.y += yDiff;
                    CL_Application.this.f.setBounds(this.frameBounds);
                }
                this.lastTimeStamp = timestamp;
            }
        }
    }

    class timeThread
    extends Thread {
        @Override
        public void run() {
            Date now = new Date();
            CL_Application.this.isAlive = true;
            while (CL_Application.this.isAlive) {
                CL_Application.this.lblTime.setText(CL_Application.this.to000000(new Date().getTime() - now.getTime()));
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

