/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Util.CL_File;
import Util.CL_Path;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class CL_ImagePreview
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = -6557051665281978032L;
    private ImageIcon thumbnail = null;
    private File file = null;
    private Color[][] m_colors = null;

    public CL_ImagePreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(100, 100));
        fc.addPropertyChangeListener(this);
    }

    public void loadImage() {
        ImageIcon tmpIcon;
        block44: {
            if (this.file == null) {
                this.thumbnail = null;
                return;
            }
            tmpIcon = null;
            if (this.file.exists()) {
                if (CL_File.getExtension(this.file) != null) {
                    if (CL_File.getExtension(this.file).toLowerCase().equals("bmp") || CL_File.getExtension(this.file).toLowerCase().equals("png") || CL_File.getExtension(this.file).toLowerCase().equals("gif") || CL_File.getExtension(this.file).toLowerCase().equals("jpg")) {
                        FileInputStream fis = null;
                        try {
                            try {
                                fis = new FileInputStream(this.file);
                                tmpIcon = new ImageIcon(this.toImage(ImageIO.read(fis)));
                            }
                            catch (Exception exception) {
                                if (fis == null) break block44;
                                try {
                                    fis.close();
                                }
                                catch (Exception exception2) {
                                    // empty catch block
                                }
                                fis = null;
                                break block44;
                            }
                        }
                        catch (Throwable throwable) {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                fis = null;
                            }
                            throw throwable;
                        }
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            fis = null;
                        }
                    } else {
                        FileInputStream fis = null;
                        try {
                            try {
                                fis = new FileInputStream(new File(String.valueOf(CL_Path.getDefault()) + "Images/no_file.jpg"));
                                tmpIcon = new ImageIcon(this.toImage(ImageIO.read(fis)));
                            }
                            catch (Exception exception) {
                                if (fis == null) break block44;
                                try {
                                    fis.close();
                                }
                                catch (Exception exception3) {
                                    // empty catch block
                                }
                                fis = null;
                                break block44;
                            }
                        }
                        catch (Throwable throwable) {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                fis = null;
                            }
                            throw throwable;
                        }
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            fis = null;
                        }
                    }
                }
            } else {
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(new File(String.valueOf(CL_Path.getDefault()) + "Images/no_file.jpg"));
                        tmpIcon = new ImageIcon(this.toImage(ImageIO.read(fis)));
                    }
                    catch (Exception exception) {
                        if (fis == null) break block44;
                        try {
                            fis.close();
                        }
                        catch (Exception exception4) {
                            // empty catch block
                        }
                        fis = null;
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        fis = null;
                    }
                    throw throwable;
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Object var2_4 = null;
                }
            }
        }
        if (tmpIcon != null) {
            this.thumbnail = tmpIcon.getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 4)) : tmpIcon;
        }
    }

    public BufferedImage generateImageARGB(int _iSize) {
        BufferedImage bi = new BufferedImage(256, 256, 2);
        Graphics2D g2D = (Graphics2D)bi.getGraphics();
        int iInterval = 5;
        int i = 0;
        while (i < 48) {
            int j = 0;
            while (j < 48) {
                g2D.setColor(this.m_colors[i][j]);
                g2D.fillRect(iInterval * i, iInterval * j, iInterval, iInterval);
                ++j;
            }
            ++i;
        }
        AffineTransform tx = new AffineTransform();
        tx.scale((double)_iSize / 256.0, (double)_iSize / 256.0);
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        BufferedImage biNew = new BufferedImage(_iSize, _iSize, 2);
        return op.filter(bi, biNew);
    }

    public Image toImage(BufferedImage bufferedImage) {
        if (bufferedImage instanceof Image) {
            return bufferedImage;
        }
        return Toolkit.getDefaultToolkit().createImage(bufferedImage.getSource());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g2D, x + 1, y + 1);
            g2D.setColor(Color.BLACK);
            g2D.setStroke(new BasicStroke(2.0f));
            g2D.drawRect(x, y, this.thumbnail.getIconWidth() + 2, this.thumbnail.getIconHeight() + 2);
        }
    }

    private void readObject(ObjectInputStream in) throws Exception {
        boolean is48x48 = false;
        String s48x48 = null;
        try {
            s48x48 = (String)in.readObject();
            is48x48 = Boolean.parseBoolean(s48x48);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is48x48) {
            in.readObject();
        }
        int i = 0;
        while (i < 64) {
            in.readObject();
            ++i;
        }
        this.m_colors = new Color[48][48];
        if (is48x48) {
            i = 0;
            while (i < 48) {
                int j = 0;
                while (j < 48) {
                    int Red = Integer.parseInt((String)in.readObject());
                    int Green = Integer.parseInt((String)in.readObject());
                    int Blue = Integer.parseInt((String)in.readObject());
                    int Alpha = Integer.parseInt((String)in.readObject());
                    this.m_colors[i][j] = new Color(Red, Green, Blue, Alpha);
                    ++j;
                }
                ++i;
            }
        } else {
            int Alpha;
            int Blue;
            int Green;
            int Red;
            int j;
            i = 0;
            while (i < 48) {
                j = 0;
                while (j < 48) {
                    Red = 255;
                    Green = 255;
                    Blue = 255;
                    Alpha = 255;
                    this.m_colors[i][j] = new Color(Red, Green, Blue, Alpha);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 32) {
                j = 0;
                while (j < 32) {
                    Red = Integer.parseInt((String)in.readObject());
                    Green = Integer.parseInt((String)in.readObject());
                    Blue = Integer.parseInt((String)in.readObject());
                    Alpha = Integer.parseInt((String)in.readObject());
                    this.m_colors[i][j] = new Color(Red, Green, Blue, Alpha);
                    ++j;
                }
                ++i;
            }
        }
    }
}

