/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;

public class CL_LinkLabel
extends JLabel {
    private static final long serialVersionUID = -625615828875643796L;
    private String url = null;
    final Color COLOR_NORMAL = Color.BLUE;
    final Color COLOR_HOVER = Color.RED;
    final Color COLOR_ACTIVE = this.COLOR_NORMAL;
    Color mouseOutDefault;

    public CL_LinkLabel(String _text, String _url) {
        super(_text);
        this.url = _url;
        this.addMouseListener();
        this.setForeground(this.COLOR_NORMAL);
        this.mouseOutDefault = this.COLOR_NORMAL;
        this.setFont(new Font("Arial Unicode MS", 1, 16));
        this.setSize((int)this.getPreferredSize().getWidth(), (int)this.getPreferredSize().getHeight());
        this.setOpaque(true);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.drawLine(2, this.getHeight() - 1, (int)this.getPreferredSize().getWidth() - 2, this.getHeight() - 1);
    }

    public void addMouseListener() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                CL_LinkLabel.this.setForeground(CL_LinkLabel.this.COLOR_ACTIVE);
                CL_LinkLabel.this.mouseOutDefault = CL_LinkLabel.this.COLOR_ACTIVE;
                if (CL_LinkLabel.this.url.contains("@")) {
                    if (Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
                        try {
                            Desktop.getDesktop().mail(new URI(CL_LinkLabel.this.url));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(new URI(CL_LinkLabel.this.url));
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
                CL_LinkLabel.this.mouseOutDefault = CL_LinkLabel.this.COLOR_ACTIVE;
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                CL_LinkLabel.this.setForeground(CL_LinkLabel.this.COLOR_HOVER);
                CL_LinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent me) {
                CL_LinkLabel.this.setForeground(CL_LinkLabel.this.mouseOutDefault);
                CL_LinkLabel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
    }
}

